<?php

/**
 * I am THE file that defines the {{generator_name}} plugin class
 * The only one.
 *
 * I extend Glb_Pugin, and take profit of all it's functionalities
 *
 * This file is distributed under the same license as the {{generator_package}} package.
 *
 * @since             {{generator_version}}
 * @link              {{generator_link}}
 * @author            {{generator_author}}
 * @package           {{generator_package}}
 */

class Glb_{{generator_sname_wc_u}} extends Glb_Plugin {

    // Define buddies, ie sub-plugins, such as admin / public controllers, and their accessibility
    protected $_buds = [
        [
            'name'          => 'admin',
            'src'           => 'controllers/class-glb-{{generator_sname_lc_d}}-admin.php',
            'class'         => 'Glb_{{generator_sname_wc_u}}_Admin',
            'conditions'    => 'IS_FROM admin WITH_CAPS manage_options'
        ],
        [
            'name'          => 'public',
            'src'           => 'controllers/class-glb-{{generator_sname_lc_d}}-public.php',
            'class'         => 'Glb_{{generator_sname_wc_u}}_Public',
            /*'conditions'    => 'WITH_CAPS glb_{{generator_sname_lc_d}}_user OR administrator OR glb_{{generator_sname_lc_d}}_admin'*/
        ],
    ];

    // Define style files and their accessibility
    protected $_styles = [
        ['handle' => 'glb-{{generator_sname_lc_d}}-admin', 'src' => 'files/css/glb-{{generator_sname_lc_d}}-admin.css', 'media' => 'all',
            'conditions' => 'IS_FROM admin WITH_CAPS manage_options<<GENERATOR_ROLES AND glb_{{generator_sname_lc_d}}_adminGENERATOR_ROLES>>'],
        ['handle' => 'glb-{{generator_sname_lc_d}}-public', 'src' => 'files/css/glb-{{generator_sname_lc_d}}-public.css', 'media' => 'all',
            'conditions' => 'IS_FROM public<<GENERATOR_ROLES WITH_CAPS glb_{{generator_sname_lc_d}}_access OR glb_{{generator_sname_lc_d}}_adminGENERATOR_ROLES>>]'],
        ['handle' => 'jquery-ui', 'src' => 'vendors/jquery-ui/{{ver}}/themes/smoothness/jquery-ui.css',
            'media' => 'all', 'ver' => '1.11.4'],
    ];

    // Define script files and their accessibility
    protected $_scripts = [
        ['handle' => 'jquery-ui', 'src' => 'vendors/jquery-ui/{{ver}}/jquery-ui.js', 'media' => 'all', 'ver' => '1.11.4'],
        ['handle' => 'glb-{{generator_sname_lc_d}}-admin', 'src' => 'files/js/glb-{{generator_sname_lc_d}}-admin.js', 'media' => 'all',
            'deps' => ['jquery'], 'conditions' => 'IS_FROM admin WITH_CAPS manage_options'],
        ['handle' => 'glb-{{generator_sname_lc_d}}-public', 'src' => 'files/js/glb-{{generator_sname_lc_d}}-public.js', 'media' => 'all',
            'deps' => ['jquery']<<GENERATOR_ROLES , 'conditions' => 'WITH_CAPS glb_{{generator_sname_lc_d}}_access'GENERATOR_ROLES>>],
        ['handle' => 'jquery-ui-dialog', 'src' => 'files/js/glb-{{generator_sname_lc_d}}-public.js', 'media' => 'all',
            'deps' => ['jquery', 'jquery-ui'], 'conditions' => 'IS_FROM admin WITH_CAPS manage_options'],
    ];

    // Settings can not be defined here, because of translation needs, so just take a look a little below
    protected $_settings = [];

	public function __construct() {
        parent::__construct();

        // here, you can define your settings
        $this->_settings = [
            'i_am_the_boss' => [
                'data_type' => 'boolean',
                'label' => __glb('Are you the boss ?'),
                'default' => true,
                'template' => 'checkbox',
                'description' => __glb('If enabled, the whole world will know.')
            ],
            'i_am_a' => [
                'data_type' => 'text',
                'label' => __glb('Are you also... ?'),
                'default' => null,
                'template' => 'select',
                'values' => ['a-girl' => __glb('A girl'), 'a-boy' => __glb('A boy'), 'a-rabbit' => __glb('A rabbit'), 'hmmm' => __glb('All of them')],
                'description' => __glb('Hmmm... no comment.')
            ],
        ];

        // and the wp actions to hook
        // if the previous simply way to add scripts is not enough for you
        $this->add_action('wp_enqueue_scripts',         array($this, 'enqueue_scripts'));
        $this->add_action('admin_enqueue_scripts',      array($this, 'enqueue_scripts'));

    }

    /**
     * Run the plugin, comes just after initialization
     */
    public function run() {
        parent::run();
        //$this->set_auth_timeout( 15, 15 );
    }

    /**
     * Enqueue scripts that need php coding
     */
    public function enqueue_scripts() {
        $settings = $this->settings->get();

        if ($this->settings->get_value('i_am_the_boss')) {
            /*
            wp_register_script( 'glb-***', $this->file_uri('files/js/glb-***.js') );
            wp_localize_script( 'glb-***', 'boss_params', array(
                    'lang' => explode('_', get_locale())[0],
                    'nonce' => $this->request->create_nonce('glb-***')
                ));
            wp_enqueue_script( 'glb-***' );
            */
        }
    }

    /**
     * Gloubi Core will dispatch this event as often as it can (hourly by default)
     * @param $args
     */
    public function event_cron($args) {
        Glb_Log::notice('{{generator_sname_lc_d}} event_cron');
    }

}
